# Cloud Service Example Project
​
Welcome to our sample project!
​
We would love to see how you code, and more importantly, how you think. This project is within our problem domain and we hope you’ll find it interesting.

Please keep things simple – we value your time and won’t nitpick unimportant details. We’re mainly interested in overall API design, a clean implementation, and good reasoning in your answers.

If you have any questions regarding this assignment, don’t hesitate to contact us via jobs@culturedcode.com before sending in your application.


## Assignment Part 1 – Designing a REST API
​
Let’s create a simple backend for a web-based to-do app. The backend should support basic use cases like logging in and dealing with to-dos. It should also provide an export feature.
​
Design a simple REST API for creating accounts and logging in, as well as creating, updating, completing, deleting and listing to-dos. To-dos have a title and can be marked as completed. To-dos are hierarchical – so any to-do can have a parent. Deleting a to-do deletes all its children.

Add an API to retrieve statistics about the average number of completed to-dos per day for both the current month as well as the last few months.
​
Last but not least, please document an API that allows users to export their to-dos. We’d like to create a zip file with all to-dos stored as JSON. Note that the creation of the archive can take some time.
​
Document your approach in a human-readable file.
​

## Assignment Part 2 – Implementing the REST API
​
Implement your design from Part 1 using a technology stack you prefer. Briefly document how it can be accessed/deployed.
​

## Assignment Part 3 – Discussion: File Attachments
​
Imagine we wanted to add support for file attachments to to-dos. Discuss how you would approach this in a real life project. Sketch the upload and download APIs and elaborate on which cloud services you would use.
​

## Assignment Part 4 – Discussion: Client Synchronization

Our Things clients are able to operate disconnected from the cloud for a prolonged period of time. Once they reconnect to the internet, they have to synchronize with the cloud. Describe a mechanism/API that enables this. Where do you see the main challenge in this task, and what are possible ways to solve it?